
#funtion to construct dataset for selected countries

combinef <- function(data,newdf_country, matchlist1, matchlist2, var2024,var2025){
  df_eu27 <- data %>%
    filter(country %in% matchlist1)%>%
    mutate(country = "EU") %>%
    mutate(
      month = factor(month, levels = month.name, labels = month.name)
    )
  
  df_selected <-data %>%
    filter(country %in% matchlist2)%>%
    mutate(
      month = factor(month, levels = month.name, labels = month.name)
    ) 
  newdf_country <- rbind(df_eu27, df_selected)
  
  var2024 <- ensym(var2024)
  var2025 <- ensym(var2025)
  
  newdf_country <- newdf_country %>%
    mutate(
      !!var2024 := as.numeric(!!var2024),
      !!var2025 := as.numeric(!!var2025))%>%
    #data available:Jan to July 
    filter(month %in% month.name[1:7]) %>%
    group_by(country, month)%>%
    summarise(
      !!var2024 := sum(!!var2024), 
      !!var2025 := sum(!!var2025))%>%
    ungroup()%>%
    group_by(country) %>%
    mutate(
      cumsum_2024 := cumsum(!!var2024),
      cumsum_2025 := cumsum(!!var2025))
  
  ###BY region (Figure 5&6)
  
  total <- data %>%
    mutate(
      month = factor(month, levels = month.name, labels = month.name),
      !!var2024 := as.numeric(!!var2024),
      !!var2025 := as.numeric(!!var2025)
    )%>%
    filter(month %in% month.name[1:7])%>%
    group_by(month)%>%
    summarise(
      !!var2024 := sum(!!var2024, na.rm = TRUE),
      !!var2025 := sum(!!var2025, na.rm = TRUE))%>%
    ungroup()%>%
    mutate(
      cumsum_2024 := cumsum(!!var2024),
      cumsum_2025 := cumsum(!!var2025))
  
  list(
    newdf_total = total,
    newdf_country = newdf_country
  )
}

IM_ready <- combinef(IM_data, "IM_maincountries", eu27, major_partners, cifval_2024, cifval_2025)

EX_ready <- combinef(EX_data, "EX_maincountries", eu27, major_partners, expval_2024, expval_2025)

IM_total <- IM_ready$newdf_total
IM_maincountries <- IM_ready$newdf_country

EX_total <- EX_ready$newdf_total  
EX_maincountries <- EX_ready$newdf_country
